define(function () {

    var component = {
        data() {
            return {};
        }
    };

    component.originalTemplate = "Compact";
    component.template = `
<wizdomWebpart data-v-525db294
  :environmentInfo="environmentInfo"
  :chromeProperties="webpartProperties.chromeProperties"
  :title="'Department Staff' | translate"
  @titleChanged="webpartProperties.title = event"
  :dynamicData="users?users.length:null" chromeType="visual" :webpartPadding="true"
  @webpart-resize="webpartResize"
>
  <div data-v-525db294 class="department-staff-container">
    <div data-v-525db294 class="msg" v-if="users==null">{{ "Loading ..." | translate }}</div>
    <div data-v-525db294 class="msg" v-else-if="users.length==0">{{ "No users in department(s)" | translate }}</div>
    <div data-v-525db294 v-else>
      <div data-v-525db294 class="ms-Persona persona-margin" v-for="user in pagedUsers" :key="user.accountName">
        <div data-v-525db294 class="ms-Persona-imageArea">
          <a data-v-525db294 :href="user.publicUrl">
            <img data-v-525db294 class="ms-Persona-image" :src="user.pictureUrl">
          </a>
        </div>
        <div data-v-525db294 class="ms-Persona-details">
          <div data-v-525db294 class="ms-Persona-primaryText">
            <a data-v-525db294 :href="user.publicUrl">{{user.name}}</a>
          </div>
        </div>
      </div>
      <pagination data-v-525db294
        class="pagination"
        v-if="users.length > pagesize"
        :pageSize="pagesize"
        :length="users.length"
        :align="'center'"
        :webpartSize="webpartSize"
        @onPageChanged="pageChanged"
        v-model="currentPage"
      ></pagination>
    </div>
  </div>
</wizdomWebpart>
`;
    component.styles = `
/*
  Your use of the content in the files referenced here are subject to the terms of the license at http://aka.ms/fabric-font-license
*/
.ms-Persona[data-v-525db294] {
  font-family: "Segoe UI WestEuropean", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
  -webkit-font-smoothing: antialiased;
  box-sizing: border-box;
  margin: 0;
  padding: 0;
  -webkit-box-shadow: none;
  -moz-box-shadow: none;
  box-shadow: none;
  color: #333333;
  font-size: 14px;
  font-weight: 400;
  line-height: 1;
  position: relative;
  width: 100%;
  height: 48px;
  display: table;
  table-layout: fixed;
  border-collapse: separate;
}
.ms-Persona .ms-ContextualHost[data-v-525db294] {
    display: none;
}
.ms-Persona-imageArea[data-v-525db294] {
  position: absolute;
  overflow: hidden;
  text-align: center;
  max-width: 48px;
  height: 48px;
  border-radius: 50%;
  z-index: 0;
  width: 100%;
  top: 0;
  left: 0;
}
@media screen and (-ms-high-contrast: active) {
.ms-Persona-imageArea[data-v-525db294] {
      border: 1px solid #ffffff;
}
}
@media screen and (-ms-high-contrast: black-on-white) {
.ms-Persona-imageArea[data-v-525db294] {
      border: 1px solid #000000;
}
}
.ms-Persona-placeholder[data-v-525db294] {
  color: #ffffff;
  position: absolute;
  right: 0;
  left: 0;
  font-size: 47px;
  top: 9px;
  z-index: 5;
}
.ms-Persona-initials[data-v-525db294] {
  color: #ffffff;
  font-size: 17px;
  font-weight: 100;
  line-height: 48px;
}
.ms-Persona-initials.ms-Persona-initials--blueLight[data-v-525db294] {
    background-color: #00bcf2;
}
.ms-Persona-initials.ms-Persona-initials--blue[data-v-525db294] {
    background-color: #0078d7;
}
.ms-Persona-initials.ms-Persona-initials--blueDark[data-v-525db294] {
    background-color: #002050;
}
.ms-Persona-initials.ms-Persona-initials--teal[data-v-525db294] {
    background-color: #008272;
}
.ms-Persona-initials.ms-Persona-initials--greenLight[data-v-525db294] {
    background-color: #bad80a;
}
.ms-Persona-initials.ms-Persona-initials--green[data-v-525db294] {
    background-color: #107c10;
}
.ms-Persona-initials.ms-Persona-initials--greenDark[data-v-525db294] {
    background-color: #004b1c;
}
.ms-Persona-initials.ms-Persona-initials--magentaLight[data-v-525db294] {
    background-color: #e3008c;
}
.ms-Persona-initials.ms-Persona-initials--magenta[data-v-525db294] {
    background-color: #b4009e;
}
.ms-Persona-initials.ms-Persona-initials--purpleLight[data-v-525db294] {
    background-color: #b4a0ff;
}
.ms-Persona-initials.ms-Persona-initials--purple[data-v-525db294] {
    background-color: #5c2d91;
}
.ms-Persona-initials.ms-Persona-initials--black[data-v-525db294] {
    background-color: #000000;
}
.ms-Persona-initials.ms-Persona-initials--orange[data-v-525db294] {
    background-color: #d83b01;
}
.ms-Persona-initials.ms-Persona-initials--red[data-v-525db294] {
    background-color: #e81123;
}
.ms-Persona-initials.ms-Persona-initials--redDark[data-v-525db294] {
    background-color: #a80000;
}
.ms-Persona-image[data-v-525db294] {
  position: absolute;
  top: 0;
  left: 0;
  height: 48px;
  z-index: 10;
  width: 100%;
}

.ms-Persona-presence[data-v-525db294] {
  background-color: #7FBA00;
  position: absolute;
  height: 12px;
  width: 12px;
  border-radius: 50%;
  top: auto;
  left: 34px;
  bottom: -1px;
  border: 2px solid #ffffff;
  text-align: center;
}
@media screen and (-ms-high-contrast: active) {
.ms-Persona-presence[data-v-525db294] {
      border-color: #000000;
      box-shadow: 0 0 0 1px #1AEBFF inset;
      color: #000000;
      background-color: #ffffff;
}
}
@media screen and (-ms-high-contrast: black-on-white) {
.ms-Persona-presence[data-v-525db294] {
      border-color: #ffffff;
      box-shadow: 0 0 0 1px #37006E inset;
      color: #ffffff;
      background-color: #000000;
}
}
.ms-Persona-presenceIcon[data-v-525db294] {
  color: #ffffff;
  font-size: 8px;
  line-height: 12px;
  vertical-align: top;
}
.ms-Persona-details[data-v-525db294] {
  padding: 0 12px;
  vertical-align: middle;
  overflow: hidden;
  text-align: left;
  padding-left: 60px;
  display: table-cell;
  width: 100%;
}
.ms-Persona-primaryText[data-v-525db294],
.ms-Persona-secondaryText[data-v-525db294],
.ms-Persona-tertiaryText[data-v-525db294],
.ms-Persona-optionalText[data-v-525db294] {
  display: block;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  width: 100%;
  overflow: hidden;
  text-overflow: ellipsis;
}
.ms-Persona-primaryText[data-v-525db294] {
  color: #333333;
  font-weight: 400;
  font-size: 17px;
  margin-top: -3px;
  line-height: 1.4;
}
.ms-Persona-secondaryText[data-v-525db294],
.ms-Persona-tertiaryText[data-v-525db294],
.ms-Persona-optionalText[data-v-525db294] {
  color: #666666;
  font-weight: 400;
  font-size: 12px;
  white-space: nowrap;
  line-height: 1.3;
}
.ms-Persona-secondaryText[data-v-525db294] {
  padding-top: 3px;
}
.ms-Persona-tertiaryText[data-v-525db294],
.ms-Persona-optionalText[data-v-525db294] {
  padding-top: 5px;
  display: none;
}
.ms-Persona.ms-Persona--tiny[data-v-525db294] {
  height: 30px;
  display: inline-block;
}
.ms-Persona.ms-Persona--tiny .ms-Persona-imageArea[data-v-525db294] {
    overflow: visible;
    display: none;
}
.ms-Persona.ms-Persona--tiny .ms-Persona-presence[data-v-525db294] {
    right: auto;
    top: 10px;
    left: 0;
    border: 0;
}
@media screen and (-ms-high-contrast: active) {
.ms-Persona.ms-Persona--tiny .ms-Persona-presence[data-v-525db294] {
        top: 9px;
        border: 1px solid #ffffff;
}
}
@media screen and (-ms-high-contrast: black-on-white) {
.ms-Persona.ms-Persona--tiny .ms-Persona-presence[data-v-525db294] {
        border: 1px solid #000000;
}
}
.ms-Persona.ms-Persona--tiny .ms-Persona-details[data-v-525db294] {
    padding-left: 20px;
}
.ms-Persona.ms-Persona--tiny .ms-Persona-primaryText[data-v-525db294] {
    font-size: 14px;
    padding-top: 9px;
}
.ms-Persona.ms-Persona--tiny .ms-Persona-secondaryText[data-v-525db294] {
    display: none;
}
.ms-Persona.ms-Persona--tiny.ms-Persona--readonly[data-v-525db294] {
  padding: 0;
  background-color: transparent;
}
.ms-Persona.ms-Persona--tiny.ms-Persona--readonly .ms-Persona-primaryText[data-v-525db294]::after {
    content: ';';
}
.ms-Persona.ms-Persona--xs[data-v-525db294],
.ms-Persona.ms-Persona--facePile[data-v-525db294],
.ms-Persona.ms-Persona--token[data-v-525db294] {
  height: 32px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-imageArea[data-v-525db294],
  .ms-Persona.ms-Persona--xs .ms-Persona-image[data-v-525db294],
  .ms-Persona.ms-Persona--facePile .ms-Persona-imageArea[data-v-525db294],
  .ms-Persona.ms-Persona--facePile .ms-Persona-image[data-v-525db294],
  .ms-Persona.ms-Persona--token .ms-Persona-imageArea[data-v-525db294],
  .ms-Persona.ms-Persona--token .ms-Persona-image[data-v-525db294] {
    max-width: 32px;
    height: 32px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-placeholder[data-v-525db294],
  .ms-Persona.ms-Persona--facePile .ms-Persona-placeholder[data-v-525db294],
  .ms-Persona.ms-Persona--token .ms-Persona-placeholder[data-v-525db294] {
    font-size: 28px;
    top: 6px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-initials[data-v-525db294],
  .ms-Persona.ms-Persona--facePile .ms-Persona-initials[data-v-525db294],
  .ms-Persona.ms-Persona--token .ms-Persona-initials[data-v-525db294] {
    font-size: 12px;
    line-height: 32px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-presence[data-v-525db294],
  .ms-Persona.ms-Persona--facePile .ms-Persona-presence[data-v-525db294],
  .ms-Persona.ms-Persona--token .ms-Persona-presence[data-v-525db294] {
    left: 19px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-details[data-v-525db294],
  .ms-Persona.ms-Persona--facePile .ms-Persona-details[data-v-525db294],
  .ms-Persona.ms-Persona--token .ms-Persona-details[data-v-525db294] {
    padding-left: 40px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-primaryText[data-v-525db294],
  .ms-Persona.ms-Persona--facePile .ms-Persona-primaryText[data-v-525db294],
  .ms-Persona.ms-Persona--token .ms-Persona-primaryText[data-v-525db294] {
    font-size: 14px;
    padding-top: 3px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-secondaryText[data-v-525db294],
  .ms-Persona.ms-Persona--facePile .ms-Persona-secondaryText[data-v-525db294],
  .ms-Persona.ms-Persona--token .ms-Persona-secondaryText[data-v-525db294] {
    display: none;
}
.ms-Persona.ms-Persona--sm[data-v-525db294] {
  height: 40px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-imageArea[data-v-525db294],
  .ms-Persona.ms-Persona--sm .ms-Persona-image[data-v-525db294] {
    max-width: 40px;
    height: 40px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-placeholder[data-v-525db294] {
    font-size: 38px;
    top: 5px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-initials[data-v-525db294] {
    font-size: 14px;
    line-height: 40px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-presence[data-v-525db294] {
    left: 27px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-details[data-v-525db294] {
    padding-left: 48px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-primaryText[data-v-525db294] {
    font-size: 14px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-primaryText[data-v-525db294],
  .ms-Persona.ms-Persona--sm .ms-Persona-secondaryText[data-v-525db294] {
    padding-top: 1px;
}
.ms-Persona.ms-Persona--lg[data-v-525db294] {
  height: 72px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-imageArea[data-v-525db294],
  .ms-Persona.ms-Persona--lg .ms-Persona-image[data-v-525db294] {
    max-width: 72px;
    height: 72px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-placeholder[data-v-525db294] {
    font-size: 67px;
    top: 10px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-initials[data-v-525db294] {
    font-size: 28px;
    line-height: 72px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-presence[data-v-525db294] {
    left: 49px;
    height: 20px;
    width: 20px;
    border-width: 3px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-presenceIcon[data-v-525db294] {
    line-height: 20px;
    font-size: 14px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-details[data-v-525db294] {
    padding-left: 84px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-secondaryText[data-v-525db294] {
    padding-top: 3px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-tertiaryText[data-v-525db294] {
    padding-top: 5px;
    display: block;
}
.ms-Persona.ms-Persona--xl[data-v-525db294] {
  height: 100px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-imageArea[data-v-525db294],
  .ms-Persona.ms-Persona--xl .ms-Persona-image[data-v-525db294] {
    max-width: 100px;
    height: 100px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-placeholder[data-v-525db294] {
    font-size: 95px;
    top: 12px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-initials[data-v-525db294] {
    font-size: 42px;
    line-height: 100px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-presence[data-v-525db294] {
    height: 28px;
    width: 28px;
    left: 71px;
    border-width: 4px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-presenceIcon[data-v-525db294] {
    line-height: 28px;
    font-size: 21px;
    position: relative;
    top: 1px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-details[data-v-525db294] {
    padding-left: 120px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-primaryText[data-v-525db294] {
    font-size: 21px;
    font-weight: 300;
    margin-top: 0;
}
.ms-Persona.ms-Persona--xl .ms-Persona-secondaryText[data-v-525db294] {
    padding-top: 2px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-tertiaryText[data-v-525db294],
  .ms-Persona.ms-Persona--xl .ms-Persona-optionalText[data-v-525db294] {
    padding-top: 5px;
    display: block;
}
.ms-Persona.ms-Persona--darkText .ms-Persona-primaryText[data-v-525db294] {
  color: #212121;
}
.ms-Persona.ms-Persona--darkText .ms-Persona-secondaryText[data-v-525db294],
.ms-Persona.ms-Persona--darkText .ms-Persona-tertiaryText[data-v-525db294],
.ms-Persona.ms-Persona--darkText .ms-Persona-optionalText[data-v-525db294] {
  color: #333333;
}
.ms-Persona.ms-Persona--selectable[data-v-525db294] {
  cursor: pointer;
  padding: 0 10px;
}
.ms-Persona.ms-Persona--selectable[data-v-525db294]:not(.ms-Persona--xl):hover, .ms-Persona.ms-Persona--selectable[data-v-525db294]:not(.ms-Persona--xl):focus {
    background-color: #deecf9;
    outline: 1px solid transparent;
}
.ms-Persona.ms-Persona--available .ms-Persona-presence[data-v-525db294] {
  background-color: #7FBA00;
}
.ms-Persona.ms-Persona--away .ms-Persona-presence[data-v-525db294] {
  background-color: #FCD116;
}
.ms-Persona.ms-Persona--away .ms-Persona-presenceIcon[data-v-525db294] {
  position: relative;
  left: 1px;
}
.ms-Persona.ms-Persona--blocked .ms-Persona-presence[data-v-525db294] {
  background-color: #ffffff;
}
.ms-Persona.ms-Persona--blocked .ms-Persona-presence[data-v-525db294]::before {
    content: '';
    width: 100%;
    height: 100%;
    position: absolute;
    top: 0;
    left: 0;
    box-shadow: 0 0 0 2px #D93B3B inset;
    border-radius: 50%;
}
.ms-Persona.ms-Persona--blocked .ms-Persona-presence[data-v-525db294]::after {
    content: '';
    width: 100%;
    height: 2px;
    background-color: #D93B3B;
    transform: rotate(-45deg);
    position: absolute;
    top: 5px;
    left: 0;
}
.ms-Persona.ms-Persona--blocked.ms-Persona--lg .ms-Persona-presence[data-v-525db294]::after {
  top: 9px;
}
.ms-Persona.ms-Persona--blocked.ms-Persona--xl .ms-Persona-presence[data-v-525db294]::after {
  top: 13px;
}
.ms-Persona.ms-Persona--busy .ms-Persona-presence[data-v-525db294] {
  background-color: #D93B3B;
}
@media screen and (-ms-high-contrast: active) {
.ms-Persona.ms-Persona--busy .ms-Persona-presence[data-v-525db294] {
      background-color: #1AEBFF;
}
}
@media screen and (-ms-high-contrast: black-on-white) {
.ms-Persona.ms-Persona--busy .ms-Persona-presence[data-v-525db294] {
      background-color: #37006E;
}
}
.ms-Persona.ms-Persona--dnd .ms-Persona-presence[data-v-525db294] {
  background-color: #E81123;
}
.ms-Persona.ms-Persona--offline .ms-Persona-presence[data-v-525db294] {
  background-color: #93ABBD;
}
@media screen and (-ms-high-contrast: active) {
.ms-Persona.ms-Persona--offline .ms-Persona-presence[data-v-525db294] {
      background-color: #000000;
      box-shadow: 0 0 0 1px #ffffff inset;
}
}
@media screen and (-ms-high-contrast: black-on-white) {
.ms-Persona.ms-Persona--offline .ms-Persona-presence[data-v-525db294] {
      background-color: #ffffff;
      box-shadow: 0 0 0 1px #000000 inset;
}
}
.ms-Persona.ms-Persona--facePile[data-v-525db294] {
  display: inline-block;
  width: auto;
}
.ms-Persona.ms-Persona--facePile[data-v-525db294]:hover {
    cursor: pointer;
}
.ms-Persona.ms-Persona--facePile .ms-Persona-imageArea[data-v-525db294] {
    position: relative;
    width: 100%;
    min-width: 32px;
}
.ms-Persona.ms-Persona--facePile .ms-Persona-initials[data-v-525db294] {
    position: relative;
}
.ms-Persona.ms-Persona--facePile .ms-Persona-details[data-v-525db294] {
    display: none;
}
.ms-Persona.ms-Persona--facePile .ms-Persona-presence[data-v-525db294] {
    display: none;
}
.ms-Persona.ms-Persona--token[data-v-525db294] {
  display: inline-flex;
  width: auto;
  background-color: #f4f4f4;
  border-radius: 20px;
  margin: 4px;
}
.ms-Persona.ms-Persona--token[data-v-525db294]:hover {
    cursor: pointer;
}
.ms-Persona.ms-Persona--token .ms-Persona-actionIcon[data-v-525db294] {
    border-radius: 20px;
    display: inline-block;
    width: 32px;
    height: 32px;
    padding: 0;
    line-height: 30px;
    transition: background-color 0.167s cubic-bezier(0.1, 0.9, 0.2, 1);
    text-align: center;
}
.ms-Persona.ms-Persona--token .ms-Persona-actionIcon[data-v-525db294]:hover {
      background-color: #eaeaea;
}
.ms-Persona.ms-Persona--token .ms-Persona-imageArea[data-v-525db294] {
    width: 100%;
    min-width: 32px;
}
.ms-Persona.ms-Persona--token .ms-Persona-details[data-v-525db294] {
    height: 30px;
    display: inline-block;
    width: auto;
    padding-right: 8px;
}
.ms-Persona.ms-Persona--token .ms-Persona-primaryText[data-v-525db294] {
    padding-top: 0;
    line-height: 34px;
}
.ms-Persona.ms-Persona--token .ms-Persona-initials[data-v-525db294] {
    position: relative;
}
.department-staff-container .persona-margin[data-v-525db294] {
  margin-bottom: 20px;
}
.department-staff-container .msg[data-v-525db294] {
  color: "[theme:neutralPrimary, default:#333333]";
}
.department-staff-container .ms-Persona-primaryText a[data-v-525db294] {
  text-decoration: none;
  color: "[theme:neutralPrimary, default:#333333]";
}
.pagination[data-v-525db294] {
  margin: 16px 0;
}


`;

    return component;

});
